pro hds_open,filename,mode,status
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Opens existing HDS file and returns status.
;
common Hds,path,hds_file_stub
;
; See whether a file is currently open (only one can be open at a time)
if hds_state() ne 0 then begin
	print,'***Error: Please close current file before opening another one!'
	status=-1
	return
endif
;
; Did the user forget to specify the file?
if n_elements(filename) eq 0 then begin
	spawn,'ls *.c??'
	filename=''
	read,'Please enter HDS file name: ',filename
endif
;
; The default mode is READ only
if n_elements(mode) eq 0 then mode='READ'
;
; Does the file exist?
result=file_search(filename,count=fcount)
if fcount ne 1 then begin
	print,'***Error(HDS_OPEN): '+filename+' does not exist!'
	status=-1
	return
endif else filename=result[0]
;
; Check whether it is an HDS file (first three bytes SDS)
openr,unit,filename,/get_lun
x=0b & y=0b & z=0b
readu,unit,x,y,z
free_lun,unit
if x ne 83 or y ne 68 or z ne 83 then begin
	print,'***Error(HDS_OPEN): file not HDS format!'
	status=-1
	return
endif
;
; Extract date portion
hds_file_stub=npoifile(filename)
;
; Extract the path
path=pathname(filename)
;
status=linknload(!external_lib,'hds_open',filename,mode)
if status ne 0 then begin
	print,'***Error(HDS_OPEN): error opening file!'
	clearstatus
	status=-1
	return
endif
;
print,'HDS-file opened; mode=',mode,'.'
status=0
;
end
