function histogramm,x,y,min=minx,max=maxx,binsize=binsize, $
	values=values,errors=errors
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Place values x in bins similar to histogram, but average corresponding
; values y and returns array of averages. Return bins in keyword values.
;
if n_elements(minx) eq 0 then minx=min(x)
if n_elements(maxx) eq 0 then maxx=max(x)
if n_elements(binsize) eq 0 then binsize=1
;
;
f=histogram(x,min=minx,max=maxx,binsize=binsize,reverse_indices=r)
n=n_elements(f)
values=findgen(n)*binsize+minx+binsize/2
if n_elements(y) eq 0 then return,f
;
y_mean=fltarr(n)
errors=fltarr(n)
for i=0,n-1 do begin
	if r[i] ne r[i+1] then begin
		y_mean[i]=avg(y[r[r[i]:r[i+1]-1]])
		errors[i]=stddev(y[r[r[i]:r[i+1]-1]])
	endif
endfor
return,y_mean
;
end
