pro histograph,y,min=miny,max=maxy,binsize=binsize, $
	oplot=oplot,color=color,xtitle=xtitle,chisq=chisq
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
if n_elements(miny) eq 0 then miny=min(y)
if n_elements(maxy) eq 0 then maxy=max(y)
if n_elements(binsize) eq 0 then binsize=1
if n_elements(color) eq 0 then color=tci(1)
if n_elements(xtitle) eq 0 then xtitle=''
;
f=histogram(y,min=miny,max=maxy,binsize=binsize)
n=n_elements(f)
x=findgen(n)*binsize+miny
x2=fltarr(2*n)
x2[indgen(n)*2]=x
x2[indgen(n)*2+1]=x+binsize
f2=fltarr(2*n)
f2[indgen(n)*2]=f
f2[indgen(n)*2+1]=f
if keyword_set(oplot) then oplot,x2,f2,psym=0,color=color $
		      else plot,x2,f2,psym=0,xtitle=xtitle
if keyword_set(chisq) then oplot,x,max(f)*exp(-x^2/sqrt(chisq)),psym=0
;
end
