function hms,x_in,wds=wds,scan=scan,gaia=gaia,aspro=aspro,simbad=simbad
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return formatted string for x in hours. x may be array.
;
if n_elements(wds) eq 0 then wds=0
if n_elements(scan) eq 0 then scan=0
if n_elements(gaia) eq 0 then gaia=0
if n_elements(aspro) eq 0 then aspro=0
if n_elements(simbad) eq 0 then simbad=0
;
x=x_in
index=where(x lt 0,count)
; sign=strarr(n_elements(x)) & sign(*)='+'
; if count gt 0 then sign(index)='-'
if count gt 0 then x[index]=x[index]+24
x=abs(x)
hour=fix(x)
min=fix((x-hour)*60)
sec=double(((x-hour)*60-min)*60)
if wds then begin
label= strcompress(string(hour,format='(i2.2)')) $
      +strcompress(string(min,format='(i2.2)')) $
      +strcompress(string(nint((sec/60)*10),format='(i1.1)'))
endif else if scan then begin
label= strcompress(string(hour,format='(i2.2)'))+'h ' $
      +strcompress(string(min,format='(i2.2)'))+'m ' ;$
;     +strcompress(string(nint(sec),format='(i2.2)'))+'s'
endif else if gaia then begin
label= strcompress(string(hour,format='(i2.2)'))+' ' $
      +strcompress(string(min,format='(i2.2)'))+' ' $
      +strcompress(string(fix(sec),format='(i2.2)'))+'.' $
      +strmid(string(sec-fix(sec),format='(f7.5)'),2,5)
endif else if aspro then begin
label= strcompress(string(hour,format='(i2.2)'))+':' $
      +strcompress(string(min,format='(i2.2)'))+':' $
      +strcompress(string(fix(sec),format='(i2.2)'))+'.' $
      +strmid(string(sec-fix(sec),format='(f6.4)'),2,4)
endif else if simbad then begin
label= strcompress(string(hour,format='(i2.2)'))+' ' $
      +strcompress(string(min,format='(i2.2)'))+' ' $
      +strcompress(string(fix(sec),format='(i2.2)'))+'.' $
      +strmid(string(sec-fix(sec),format='(f7.5)'),2,5)
endif else begin
label= strcompress(string(hour,format='(i2.2)'))+'h ' $
      +strcompress(string(min,format='(i2.2)'))+'m ' $
      +strcompress(string(sec,format='(f4.1)'))+'s'
endelse
if n_elements(label) eq 1 then return,label[0] else return,label
;
end
