function hms2h,h_in,sb9=sb9
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return floating point time in hours from hh:mm:ss.sssss input. Arrays OK.
;
if n_elements(sb9) eq 0 then sb9=0
;
h=strtrim(h_in,2)
index=where(strlen(h) eq 0,count)
if count gt 0 then h[index]='00:00:00.00000'
ipos=strpos(h,'.')
index=where(ipos eq -1,count)
if count gt 0 then h[index]=h[index]+'.0'
if sb9 then begin
	t=double(strmid(h,0,2))
	t=t+double(strmid(h,2,2))/60
	t=t+double(strmid(h,4,2))/3600
	t=t+double('0.'+strmid(h,6))/3600
endif else begin
	t=double(strmid(h,0,2))
	t=t+double(strmid(h,3,2))/60
	t=t+double(strmid(h,6,8))/3600	; consider maximum 9 significant figures
endelse
return,t
;
end
