function horizon2azel,h_coord
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Convert horizontal coordinates (xyz) to azimuth angle (0=N, 90=W)
; and elevation. xyz is east,north,up.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
;
a_coord=h_coord[0:1,*]
a_coord[0,*]=(atan(h_coord[1,*],h_coord[0,*])*RAD+270) mod 360
a_coord[1,*]=(atan(h_coord[2,*],sqrt(h_coord[0,*]^2+h_coord[1,*]^2)))*RAD
;
return,a_coord
;
end
