function horizon2equatorial,h_coord,utc
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Convert station coordinates from horizon system to equatorial system
; X,Y,Z, defined by Thompson, Moran and Swenson  "Interferometry and Synthesis
; in Radio Astronomy", page 86 (1st Edition).
; "X and Y are measured in a plane parallel to the Earth's equator, X in the
; meridian plane (defined as the plane through the poles of the Earth and the
; reference point in the array), Y towards the East, and Z is measured
; towards the north pole.
;
; Horizon coordinates xyz are east,north,up
;
; As in all following coordinate transformation function, inputs can be
; natural order arrays, i.e. (2) or (2,*) and (3) or (3,*).
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
;
if n_elements(utc) eq 0 then utc=0.d0
longitude=polarmotion(utc,latitude)
;
e_coord=h_coord	; to preserve type
;
e_coord[0,*]=cos(Latitude/RAD)*h_coord[2,*] $
   	    -sin(Latitude/RAD)*h_coord[1,*]
e_coord[1,*]=h_coord[0,*]
e_coord[2,*]=cos(Latitude/RAD)*h_coord[1,*] $
	    +sin(Latitude/RAD)*h_coord[2,*]
;
return,e_coord
;
end
