pro i_binaries
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Estimate orbital inclination for double-classification binaries. Do
; consistency checks. Requires massfunction, mass1/2, p[d], d[pc].
; The Batten catalog has f(m) values for SB1, and m*sin(i)^3 for SB2's.
;
common StarBase,StarTable,Notes
;
index=where((StarTable.mass ne 0) $
	and (StarTable.mass2 ne 0) $
	and (StarTable.mf ne 0),count)
print,'Number of single-lined double-classification binaries =',count
if count gt 0 then begin
	flags=StarTable[index].sflag
	mf=StarTable[index].mf
	m1=StarTable[index].mass
	m2=StarTable[index].mass2
	i1=(mf*(m1+m2)^2/m2^3)^(1./3)
	bad_index=where(i1 gt 1.1,bad_count)
	if bad_count gt 0 then flags[bad_index]='!'
	bad_index=where(i1 gt 1.0,bad_count)
	if bad_count gt 0 then i1[bad_index]=1.0
	StarTable[index].i=asin(i1)/!pi*180
	StarTable[index].sflag=flags
endif
;
index=where((StarTable.mass ne 0) $
	and (StarTable.mass2 ne 0) $
	and (StarTable.m1sin3i ne 0) $
	and (StarTable.m2sin3i ne 0),count)
print,'Number of double-lined    s/d-classification binaries =',count
if count gt 0 then begin
	i1=(StarTable[index].m1sin3i/StarTable[index].mass)^(1./3)
	i2=(StarTable[index].m2sin3i/StarTable[index].mass2)^(1./3)
;
;	Flag inconsistent results
	flags=StarTable[index].sflag
	bad_index=where((i1 gt 1.1) or (i2 gt 1.1),bad_count)
	if bad_count gt 0 then flags[bad_index]='!'
	i_ratio=i1/i2
	bad_index=where((i_ratio lt 0.9) or (i_ratio gt 1.1),bad_count)
	if bad_count gt 0 then flags[bad_index]='!'
;
;	Compute inclination
	bad_index=where((i1 gt 1.0) or (i2 gt 1.0),bad_count)
	if bad_count gt 0 then begin
		i1[bad_index]=1.0
		i2[bad_index]=1.0
	endif
	StarTable[index].i=asin(sqrt(i1*i2))*180/!pi
	StarTable[index].sflag=flags
endif
;
end
