function imgmap,map,uv_cell=uv_cell_in,uv_taper=uv_taper
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Creates an image from a map using the fast Fourier transform.
; Map coordinates are in mas. map.x corresponds to RA and increases towards
; East, i.e. left. Lambda [m].
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
; Determine mean resolution and maximum size
x_size=max(map.xcc)-min(map.xcc)
y_size=max(map.ycc)-min(map.ycc)
c_size=sqrt((x_size*y_size)/n_elements(map.fcc))
i_size=sqrt(x_size*y_size)
;
fringespacing_min=c_size/2	; c_size*4 (pearldata), but we need larger image
max_uvr=(180/!pi)*3600000/fringespacing_min
imsize=[201,201]	; must be odd numbers
uv_cell=max_uvr/imsize[0]
if n_elements(uv_cell_in) ne 0 then $
	if uv_cell_in eq 0 then print,'uv_cell=',uv_cell else uv_cell=uv_cell_in
if n_elements(uv_taper) eq 0 then uv_taper=100.
;
uvmap=set_uvc(imsize,uv_cell,1)
cvmap=complexarr(n_elements(uvmap.u))
;
; Image has to have N top and E to the left
u=-uvmap.u
v=-uvmap.v
;
RAD=180/pi_circle
MAS=1/3600000.d0
;
for i=0,map.icc[0]-1 do begin
	arg=2*pi_circle*(u*map.xcc[i]+v*map.ycc[i])*MAS/RAD
	cvmap=cvmap+map.fcc[i]*complex(cos(arg),sin(arg))
endfor
;
cvmap=reform(cvmap,imsize)/total(map.fcc)
;
; Apply taper (equals convolution resulting image with Gaussian beam)
u=reform(u,201,201)
v=reform(v,201,201)
r=sqrt(u^2+v^2)/uv_cell
y=(-(r/uv_taper)^2)
result=machar() & tiny=result.xmin*1e6 & toosmall=alog(tiny)
index=where(y lt toosmall,count)
if count gt 0 then y[index]=1
cvmap=cvmap*exp(y)
if count gt 0 then cvmap[index]=0
; tvscl,float(cvmap)
image=shift(float(fft(cvmap,/inverse,/center)),imsize[0]/2,imsize[1]/2)
;
return,image
;
end
