function imgvis,u,v,lamda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Computes visibilities for OYSTER/PEARL "effective temperature" images.
;
; u[lamda],v[lamda],lamda[m]
;
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
n=n_elements(u)
nl=n_elements(lamda)
;
; nr is the number of non-zero effective temperature regions
ir=where(rt ne 0,nr)
sf=fltarr(nl,nr)
;
for i=0,nr-1 do begin
;	This was the old call for stellar atmospheres
;	ld_coeffs=limblinear(rt(i),rg(i),lamda*1d9,fluxes)
;	Now we call a more general function for SEDs
	fluxes=stellarfluxes( $
		{teff:-rt[i],logg:rg[i], $
		 diameter:1.0,ratio:1.0, $
		 type:13}, $
		 lamda,ld_coeffs)
;	sf(*,i)=fluxes/max(fluxes)	; for Pearl Version 7.06
	sf[*,i]=fluxes
endfor
;
return,mft(cm,complexarr(n),reform(u,n),reform(v,n),(indgen(n) mod nl)+1, $
	rt,sf,/normalize)
;
; Call in Version 7.06
return,mft(cm,complexarr(n),reform(u,n),reform(v,n),rt,sf, $
	(indgen(n) mod nl)+1,/normalize)
;
end
