function imlcparse,r,p
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read output imlcout.dat of lc15 and extract r_side values and derivatives.
; Also return radii in solar units and periastron and conjunction phases (p).
;
f=file_search('imlcout.dat')
if strlen(f[0]) eq 0 then return,fltarr(2,2)
;
l=''
status=dc_read_fixed('imlcout.dat',l,/col,format='(a140)')
;
index=where(strpos(l,'(Mean Radius)/Rsun') ge 0,count) & index=index[0]
i=1
while strlen(strcompress(l[index+i],/remove_all)) eq 0 do i=i+1
r=fltarr(2)
words=nameparse(l[index+i])
r[0]=float(words[2])
words=nameparse(l[index+i+1])
r[1]=float(words[2])
;
index=where(strpos(l,'inferior') ge 0,count) & index=index[0]
i=1
while strlen(strcompress(l[index+i],/remove_all)) eq 0 do i=i+1
p=fltarr(3)
words=nameparse(l[index+i+2])
p[0]=float(words[6])
p[1]=float(words[7])
p[2]=float(words[8])
;
index=where(strpos(l,'r side') ge 0,count) & index=index[0]
i=1
while strlen(strcompress(l[index+i],/remove_all)) eq 0 do i=i+1
s=fltarr(2,2)
words=nameparse(l[index+i])
s[*,0]=float(words[5:6])
words=nameparse(l[index+i+1])
s[*,1]=float(words[5:6])
;
return,s
;
end
