pro inchav
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
        ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
; Check presence of data
if checkdata([8,9,16,21]) ne 0 then return
;
for k=0,n_elements(scans)-1 do begin
;
kk=scans[k].Iscan-1
for i=0,GenConfig.NumSid-1 do begin
;
	if Sol0[kk] ge 0 and SolN[kk] ge 0 then begin
		x=ParX[i,Sol0[kk]:SolN[kk]]
		xerr=ParXErr[i,Sol0[kk]:SolN[kk]]
		y=ParY[i,Sol0[kk]:SolN[kk]]
		yerr=ParYErr[i,Sol0[kk]:SolN[kk]]
		z=ParZ[i,Sol0[kk]:SolN[kk]]
		zerr=ParZErr[i,Sol0[kk]:SolN[kk]]
		j=where(xerr gt 0 and yerr gt 0 and zerr gt 0,count)
		if count gt 0 then begin
			scans[kk].ParX(i)=avg(x[j])
			scans[kk].ParY(i)=avg(y[j])
			scans[kk].ParZ(i)=avg(z[j])
			if count gt 1 then begin
				scans[kk].ParXErr(i)=stddev(double(x[j]))/sqrt(count)
				scans[kk].ParYErr(i)=stddev(double(y[j]))/sqrt(count)
				scans[kk].ParZErr(i)=stddev(double(z[j]))/sqrt(count)
			endif else begin
				scans[kk].ParXErr(i)=ParXErr[j]
				scans[kk].ParYErr(i)=ParYErr[j]
				scans[kk].ParZErr(i)=ParZErr[j]
			endelse
		endif else begin
			scans[kk].ParX(i)=0
			scans[kk].ParXErr(i)=-1
			scans[kk].ParY(i)=0
			scans[kk].ParYErr(i)=-1
			scans[kk].ParZ(i)=0
			scans[kk].ParZErr(i)=-1
		endelse
	endif else begin
		scans[kk].ParX(i)=0
		scans[kk].ParXErr(i)=-1
		scans[kk].ParY(i)=0
		scans[kk].ParYErr(i)=-1
		scans[kk].ParZ(i)=0
		scans[kk].ParZErr(i)=-1
	endelse
;
endfor
;
endfor
;
print,'Finished averaging.'
;
end
