pro init_candid
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Quick/minimal setup of CANDID Python script for companion detection.
;
common Hds,path,hds_file_stub
common StarBase,StarTable,Notes
common ModelFit,parameters,ds_options
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(startable) gt 1 then begin
	print,'Only one dataset of a single target can be processed!'
	return
endif
file_stub=startable.starid+'_'+Date
;
ncpu=!cpu.hw_ncpu
;
file_name=hds_file_stub+'.inp'
openw,unit,file_name,/get_lun
;
printf,unit,"import candid"
printf,unit,"import time"
printf,unit,"import os"
printf,unit,"from matplotlib import pyplot as plt"
printf,unit,"candid.CONFIG['long exec warning'] = None"
printf,unit,"candid.CONFIG['Ncores'] = "+string(ncpu)
printf,unit,"global data"
printf,unit,"data=candid.Open('"+hds_file_stub+".fits')"
printf,unit,"data.observables=['v2','cp']"
printf,unit,"data.chi2Map(rmin=0,rmax=10,step=1)"
printf,unit,"data.fitMap(rmin=0,rmax=10,step=1)"
printf,unit,"plt.savefig("+hds_file_stub+"_'chi2Map.pdf')"
printf,unit,"plt.close(0)"
printf,unit,"plt.savefig("+hds_file_stub+"_'fitMap1.pdf')"
printf,unit,"plt.close(1)"
printf,unit,"plt.savefig("+hds_file_stub+"_'fitMap2.pdf')"
printf,unit,"plt.close(1)"
;
;printf,unit,"data.fitMap(fig=1,rmin=0,rmax=10,step=1,fratio=20,"+$
;	"addParam={'diam*': 1.0},doNotFit={'diam*'},"+$
;	"autoSaveFig='"+file_stub+".pdf')"
;
free_lun,unit
;
print,'File '+file_name+' written, please check data file extension!'
;
end
