function init_class,class,datascans
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Bundles a few class-specific plot initializations.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common Tables,ScanTable,BGTable,StationTable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
        ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
;
if n_params() eq 2 then do_scans=1 else do_scans=0
;
if n_elements(GenConfig) eq 0 then begin
	print,'***Error(INIT_CLASS): GenConfig undefined!'
	return,-1
endif
;
nib=GenConfig.NumSid
nob=GenConfig.NumOutBeam
ntr=GenConfig.NumTriple
mch=max([GenConfig.NumSpecChan,2])
mbl=max([GenConfig.NumBaseline,2])
;
case class of
;	Pointdata
	'point' :begin
		 item=1
		 !p.psym=3
		 npt=n_elements(PointTime)
		 if do_scans and npt gt 0 then begin
		 starids=strarr(npt)
		 scanids=intarr(npt)
		 for i=0,n_elements(Iscan)-1 do begin
			starids[Rec0[i]:RecN[i]]=StarId[i]
			scanids[Rec0[i]:RecN[i]]=Iscan[i]
		 endfor
		 datascan={starid:'',time:0.d0,iscan:0}
		 datascans=replicate(datascan,npt)
		 datascans.starid=starids
		 datascans.time=PointTime
		 datascans.iscan=scanids
		 endif
		 mpt=long(total(scantable.numpoint))
		 end
	'delay' :begin
		 item=1
		 !p.psym=3
		 npt=n_elements(PointTime)
		 if do_scans and npt gt 0 then begin
		 starids=strarr(npt)
		 for i=0,n_elements(Iscan)-1 do $
			starids[Rec0[i]:RecN[i]]=StarId[i]
		 datascan={starid:'',time:0.d0}
		 datascans=replicate(datascan,npt)
		 datascans.starid=starids
		 datascans.time=PointTime
		 endif
		 mpt=long(total(scantable.numpoint))
		 end
;	Background scans
	'bg'    :begin
		 item=19
		 !p.psym=1
		 npt=n_elements(bgtable)
		 if do_scans and npt gt 0 then begin
		 starids=strarr(n_elements(bgtable))
		 for i=0,n_elements(starids)-1 do starids[i]= $
			scantable[long(where(scantable.scanid eq $
				bgtable[i].scanid),0)].starid
		 datascan={starid:'',time:0.d0}
		 datascans=replicate(datascan,npt)
		 if npt gt 1 then begin
		 	datascans.starid=starids
		 	datascans.time=bgtable.time
		 endif else begin
		 	datascans.starid=starids[0]
		 	datascans.time=bgtable[0].time
		 endelse
		 endif
		 if n_elements(scantable) ne 0 then mpt=n_elements(scantable)*2 $
					       else mpt=npt*2
		 end
;	Scans (single night)
	'scan'  :begin
		 item=22
		 !p.psym=1
		 npt=n_elements(scans)
		 if do_scans and npt gt 0 then datascans=scans
		 mpt=npt
		 end
	'ncal'  :begin
		 item=22
		 !p.psym=1
		 npt=n_elements(scans)
		 if do_scans and npt gt 0 then datascans=scans
		 mpt=npt
		 end
	'astrom':begin
		 item=22
		 !p.psym=1
		 npt=n_elements(scans)
		 if do_scans and npt gt 0 then datascans=scans
		 mpt=npt
		 end
	'seeing':begin
		 item=22
		 !p.psym=1
		 npt=n_elements(scans)
		 if do_scans and npt gt 0 then datascans=scans
		 mpt=npt
		 end
	'phot'	:begin
		 item=22
		 !p.psym=1
		 npt=n_elements(scans)
		 if do_scans and npt gt 0 then datascans=scans
		 mpt=npt
		 end
	'uv'    :begin
		 item=25
		 !p.psym=3
		 npt=n_elements(scans)
		 if do_scans and npt gt 0 then datascans=scans
		 mpt=npt
		 end
;	Scans (multiple nights)
	'amoeba':begin
		 item=22
		 !p.psym=1
		 npt=n_elements(scans)
		 if do_scans and npt gt 0 then datascans=scans
		 nib=max(GenInfo.numsid)
		 nob=max(GenInfo.numoutbeam)
		 ntr=max(GenInfo.numtriple)
		 mch=max(GenInfo.numspecchan)
	 	 mbl=max(GenInfo.numbaseline)
		 mpt=npt
		 mpt=1000 	; simulated data might have this many scans
		 end
	'volvox':begin
		 item=22
		 !p.psym=1
		 npt=n_elements(scans)
		 if do_scans and npt gt 0 then datascans=scans
		 nib=max(GenInfo.numsid)
		 nob=max(GenInfo.numoutbeam)
		 ntr=max(GenInfo.numtriple)
		 mch=max(GenInfo.numspecchan)
	 	 mbl=max(GenInfo.numbaseline)
		 mpt=npt
		 mpt=1000 	; simulated data might have this many scans
		 end
	'metro' :begin
		 item=60
		 !p.psym=3
		 npt=n_elements(MetroTime)
		 if do_scans and npt gt 0 then begin
		 starids=strarr(npt) & starids[*]='CCCslew'
		 for i=0,n_elements(scantable)-1 do begin
			if SolN[i] ge 0 then $
			starids[Sol0[i]:SolN[i]]=scantable[i].StarId
		 endfor
		 datascan={starid:'',time:0.d0}
		 datascans=replicate(datascan,npt)
		 datascans.starid=starids
		 datascans.time=MetroTime
		 endif
		 mpt=npt
		 end
	   else :begin
		 print,'***Error(SET_INITPARMS): unknown class:',class,'!'
		 return,-1
		 end
endcase
if npt eq 0 then begin
	print,'***Error(INIT_CLASS): no data!'
	return,-1
endif
if mpt eq 0 then begin
	print,'***Error(INIT_CLASS): reload scantable from .con file!'
	return,-1
endif
return,[item,nib,nob,ntr,mch,mbl,mpt]
;
end
