function init_fitinterferometry
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Initialize parameters for modelfit. Clear only the parameters listed
; for the interferometric modelfit.
;
; Return non-zero value to indicate error occured.
;
common ModelFit,parameters,ds_options
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
if n_elements(gen_model) eq 0 then begin
	print,'***Error(INIT_FITINTERFEROMETRY): no model!'
	return,-1
endif
;
if n_elements(parameters) eq 0 then begin
	num_system=1
	component=alloc_component()
	parameters=replicate(component,num_star()+num_binary()+num_system)
endif else begin
	for i=0,n_elements(parameters.component)-1 do begin
;		index=where(parameters(i).names eq 'Rho' $
;			 or parameters(i).names eq 'Theta',count)
;		if count gt 0 then parameters(i).component=''
		erase=0
		if strlen(parameters[i].component) eq 1 then erase=1
		index=where((parameters[i].names eq 'Rho' $
			or parameters[i].names eq 'Theta') $
			and strlen(parameters[i].names) ne 0,erase)
		if erase gt 0 then begin
			parameters[i].component=''
			parameters[i].names=''
		endif
	endfor
endelse
;
nights=''
;
return,0
;
end
