function init_indexsel,stream
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This routine is called by init_plot when initializing a minimum requirement
; selection for plotting. It also can be called to reset the data selection
; in a particular stream. Initializes all variables in SelDirectives, except
; st_dir & st_sel. Completes initialization of DataSelInfo.
;
common SelDirs,nt_dir,nt_sel,st_dir,st_sel,x_dir,y_dir,z_dir,x_sel,y_sel,z_sel
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
;
if n_elements(stream) eq 0 then begin
	print,'***Error(INIT_INDEXSEL): stream undefined!'
	return,-1
endif
if n_elements(class) eq 0 then begin
	print,'***Error(INIT_INDEXSEL): class undefined!'
	return,-1
endif
;
; Initialize directives
;
; If you change any of these, you have to change initially displayed button
; in ww_datasel too!
dir={bl:'Current',tr:'Current',ch:'Current',pt:'All'}
;
; Initialize user input selection:
;
parms=init_class(class)
mtr=parms[3] > 1
mch=parms[4]
mbl=parms[5]
mpt=parms[6]
if mch*mbl*mpt eq 0 then return,-1
sel={ch:intarr(mch),bl:intarr(mbl),tr:intarr(mtr),pt:lonarr(mpt)}
;
; Do the data selection:
;
case stream of
	'x':i=ds_x.item
	'y':i=ds_y.item
	'z':i=ds_z.item
       else:begin
	    print,'***Error(INIT_INDEXSEL): unknown stream:',stream
	    return,-1
	    end
endcase
ds={item:i,ib:0,ob:0,tr:0,ch:-indgen(mch),bl:-indgen(mbl),pt:lindgen(mpt)}
;
; Finally, assign the items to the stream variables:
case stream of
	'x':begin
	    x_dir=dir
	    x_sel=sel
	    ds_x=ds
	    end
	'y':begin
	    y_dir=dir
	    y_sel=sel
	    ds_y=ds
	    end
	'z':begin
	    z_dir=dir
	    z_sel=sel
	    ds_z=ds
	    end
endcase
;
return,0
;
end
