function init_plot,data_class,slice_class
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This is the first routine to be called when preparing a plot of class
; data_class/slice_class. It calls init_indexsel once for each data stream
; (x, y, and z) to complete the initialization in order to meet minimum
; selection requirements.
;
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common SelDirs,nt_dir,nt_sel,st_dir,st_sel,x_dir,y_dir,z_dir,x_sel,y_sel,z_sel
;
; Initialize DataSelInfo first:
;
if n_elements(data_class) eq 0 then begin
	print,'***Error(INIT_PLOT): class not defined!'
	return,-1
endif
;
if n_elements(slice_class) eq 0 then begin
	print,'***Error(INIT_PLOT): slice not defined!'
	return,-1
endif
;
; Default axis item is Time
parms=init_class(data_class)
if parms[0] eq -1 then return,-1
i=parms[0]
ds_x={item:i}
ds_y={item:i}
ds_z={item:i}
;
class=data_class
slice=slice_class
type=''
;
ds_nights=''
ds_stars=''
;
ps_options=alloc_ps_options()
;
; Include classes here which do not allow the selection of axes
if class eq 'ncal' then begin
	ds_x.item=0
	ds_y.item=0
endif
;
; Now initialize SelDirectives:
;
; Nights:
nt_dir='All'; If you change this, change 'current' keyword in ww_plot too!
nt_sel=''
;
; Stars:
st_dir='All'; If you change this, change 'current' keyword in ww_plot too!
st_sel=''
;
if init_indexsel('x') ne 0 then return,-1
if init_indexsel('y') ne 0 then return,-1
if init_indexsel('z') ne 0 then return,-1
;
; Set a few IDL plot options
!p.charsize=1.5		; Character size
!x.style=18		; No setting X axis minimum to 0, extend axis 5%
!y.style=18		; No setting Y axis minimum to 0, extend axis 5%
!z.style=18		; No setting Z axis minimum to 0, extend axis 5%
!x.ticks=0
!y.ticks=0
!z.ticks=0
;
return,0
;
end
