function instrument_id,sysid,beamcombinerid=beamcombinerid
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return the instrument ID for the given system and beam combiner ID,
; e.g. VLTI and beamcombinerid=1, or sysid=VLTI/MIDI-N-PRISM.
; If beamcombinerid is not specified, read from genconfig.
; System refers to the interferometer (e.g. NPOI), instrument to the combiner.
; For aperture masks, system should be the instrument name (e.g. NACO),
; and instrument refers to the specific mask (e.g. 7Holes)
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Mark3,mark3_baselines,mark3_configs,mark3_cat,mark3_bsc
;
if n_elements(sysid) eq 0 then sysid=''
if n_elements(beamcombinerid) eq 0 then beamcombinerid=0
;
; This is the easy case, sysid must be composed of array/instrument
i=strpos(sysid,'/')
if i ge 0 then return,strmid(sysid,i+1,strlen(sysid)-(i+1))
;
; Otherwise, we have to look up the beam combiner ID
if n_elements(size(genconfig)) eq 3 then begin
	if beamcombinerid eq 0 then return,''
endif else begin
	if beamcombinerid eq 0 then $
	   beamcombinerid=genconfig.beamcombinerid
endelse
;
if system_id(sysid) eq 'T-ReCS' then begin
	case beamcombinerid of
	1:return,'7Holes-Ks'
	endcase
endif
if system_id(sysid) eq 'NACO' then begin
	case beamcombinerid of
	1:return,'7Holes'
	endcase
endif
if system_id(sysid) eq 'ISI' then begin
	case beamcombinerid of
	1:return,'4'
	endcase
endif
if system_id(sysid) eq 'Mark3' then begin
	return,mark3_configs[beamcombinerid]
	case beamcombinerid of
	1:return,'450'
	2:return,'500'
	endcase
endif
if system_id(sysid) eq 'SUSI' then begin
	case beamcombinerid of
	1:return,'PAVO'
	endcase
endif
if system_id(sysid) eq 'PTI' then begin
	case beamcombinerid of
	1:return,'K1'
	2:return,'K5'
	endcase
endif
if system_id(sysid) eq 'IOTA' then begin
	case beamcombinerid of
	1:return,'IONIC3'
	endcase
endif
if system_id(sysid) eq 'NPOI' then begin
	case beamcombinerid of
	1:return,'3way'
	2:return,'6way'
	9:return,'nway'
     else:return,'3way'
	endcase
endif
if system_id(sysid) eq 'CHARA' then begin
	case beamcombinerid of
	10:return,'CLASSIC'
	20:return,'CLIMB'
	30:return,'H_PRISM'
	31:return,'MIRC-LR'
	32:return,'MIRC-MR'
	33:return,'MIRC-HR'
	endcase
endif
if system_id(sysid) eq 'VLTI' then begin
	if beamcombinerid eq 0 then return,'UNKNOWN'
	case beamcombinerid of
	 1:return,'VINCI'
	11:return,'VINCI-MONA'
	12:return,'VINCI-IONIC'
	 2:return,'MIDI'
	21:return,'MIDI-N-PRISM'
	22:return,'MIDI-N-GRISM'
	 3:return,'AMBER'
	31:return,'AMBER-LR'
	32:return,'AMBER-MR'
	33:return,'AMBER-HR'
	 4:return,'PIONIER'
	41:return,'PIONIER-GRISM'
	42:return,'PIONIER-FREE'
	 5:return,'GRAVITY'
	51:return,'GRAVITY-LR'
	52:return,'GRAVITY-MR'
	53:return,'GRAVITY-HR'
	 6:return,'MATISSE'
	61:return,'MATISSE-LN'	; generic L+N band files
	62:return,'MATISSE-L-LR'
	63:return,'MATISSE-L-MR'
	64:return,'MATISSE-L-HR'
	65:return,'MATISSE-L-HP'
	66:return,'MATISSE-N-LR'
	67:return,'MATISSE-N-HR'
	endcase
endif
return,''
;
end
