pro interferograms_event,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common InterferogramsLocal,g,a,x,cw,bw,nw,i_wid
;
result=size(event)
if result[n_elements(result)-2] ne 8 then begin
	dmax=3e-6
	nmax=100
	x=(findgen(nmax)/(nmax-1)-0.5)*2*dmax
;
	cw=700e-9
	bw=200e-9
	nw=100
	l=(findgen(nw)/(nw-1)-0.5)*bw+cw
	g=0.
	a=0.
endif else begin
	widget_control,event.id,get_uvalue=slider,get_value=value
	value=value[0]
	case slider of
		'g':g=value*1e-6
		'a':a=value*1000
		'w':bw=value*1e-9
	endcase
endelse
;
l=(findgen(nw)/(nw-1)-0.5)*bw+cw
nu=2.99e8/l
arg=2*!pi*(x#(1/l))
;
n=n_elements(x)
for i=0,nw-1 do arg[*,i]=arg[*,i]+2*!pi*g/l[i]
for i=0,nw-1 do arg[*,i]=arg[*,i]+a*(edlen(l[i]/1e-6)-1)
;
; i=50
; j=1
; print,'Group delay=',((arg(i,j)-arg(i,j-1))/(nu(j)-nu(j-1)))/(2*!pi)*2.99e14
;
f=cos(arg)
;
plot,x,total(f,2)
;
end
