function iq_total,l,a,s,d
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute image quality at wavelength l[m] and airmass a, given zenith seeing
; s["] and telescope diameter d[m]. The instrumental PSF is adopted as 0.2".
;
l0=500e-9	; DIMM wavelength [m]
lo=23.		; Paranal outer scale [m]
;
x=1+fkolb(d)*2.183*(fried_r0(l,a,s)/lo)^0.356
index=where(x lt 0,count)
if count gt 0 then x[index]=0
fwhm_a=s*(l/l0)^(-0.2)*a^0.6*sqrt(x)
;
fwhm_t=((l/d)/!pi)*180.*3600
;
fwhm_i=0.2	; Instrument transfer function FWHM
;
return,sqrt(fwhm_a^2+fwhm_t^2+fwhm_i^2)
;
end
