function irasid,ra,dec
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Match (ra,dec) with IRAS catalogue sources and return string array
; with IRAS IDs if found, or empty entries.
;
forward_function mrdfits
;
iras_file=!oyster_dir+'starbase/IRAS/iras_psc.fits'
if strlen(file_search(iras_file)) eq 0 then return,strarr(n_elements(ra))
;
d=mrdfits(iras_file,1,h)
d.iras_psc=strcompress(d.iras_psc,/remove_all)
index=where(strlen(d.iras_psc) gt 0)
d=d[index]
;
; Convert to hours
d.raj2000=d.raj2000/15
;
n=n_elements(ra)
id=strarr(n)
;
precision=5.0	; positional agreement to be identified [arcseconds]
;
for i=0L,n-1 do begin
	angles=winkel(ra[i],dec[i],d.raj2000,d.dej2000)
	j=where(angles eq min(angles))
;	if angles(j)*3600 lt precision then id(i)='IRAS'+d(j).iras_psc
	if angles[j]*3600 lt precision then id[i]=d[j].iras_psc
endfor
;
return,id
;
end
