function isnumeric,names,strict
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Test each element of an array of strings whether it represents a number
; or not. If strict is positive non-zero, do not even allow letters 'e', 'd',
; 'E', and 'D', which can be used in floating point numbers.
;
if n_elements(strict) eq 0 then strict=0 else strict=strict gt 0
;
result=intarr(n_elements(names))
;
for i=0,n_elements(names)-1 do begin
	ascii=byte(strcompress(names[i],/remove_all))
	index=where(ascii lt 43 or ascii gt 57 $
                 or ascii eq 44 or ascii eq 47,count)
	fp=0
	if count eq 0 then begin
		result[i]=1
	endif else if count eq 1 and not strict then begin
		case ascii[index[0]] of
			 68:fp=1
			 69:fp=1
			100:fp=1
			101:fp=1
		       else:fp=0
		endcase
		if fp eq 1 and index[0] ne 0 then result[i]=1
	endif
	jndex=where(ascii eq 43 or ascii eq 45,count)
	if count eq 2 then begin
		if fp eq 0 then result[i]=0 else begin
			if jndex[1] lt index[0] $
			or jndex[0] gt index[0] then result[i]=0
		endelse
	endif else if count gt 2 then result=0
	index=where(ascii eq 46,count)
	if count gt 1 then result[i]=0
	if count eq 1 and strlen(strcompress(names[i],/remove_all)) eq 1 then $
			   result[i]=0
endfor
;
if n_elements(result) eq 1 then return,result[0] else return,result
;
end
