pro jasondata,model
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Reads an atmospheric model by Jason Aufdenberg. These models are computed
; for specific stars and are not general models for a (Teff,log(g)) combination.
; The model parameter must not include the ".dat" suffix!
;
; This procedure writes a ".xdr" file for faster access.
;
; Adapted from M. Wittkowski.
;
common Jason,jason_mu,jason_l,jason_I
;
file=!atmospheres_dir+'aufdenberg/'+model
r=file_search(file)
if strlen(r[0]) eq 0 then begin
	print,'***Error(JASONDATA): file does not exist!'
	return
endif
;
openr,unit,file,/get_lun
;
case model of
	'gamsge':begin
		 num_l=4199
		 end
	else	:begin
		 num_l=4200
		 end
endcase
;
readf,unit,numberangles
angles=fltarr(numberangles)
readf,unit,angles
jason_mu=[0.0,sqrt(1.-angles[numberangles/2:numberangles-1]^2)]
;
; lr=fltarr(2)
fluxes=fltarr(numberangles)
;
jason_I=fltarr(1+numberangles/2,num_l)
jason_l=fltarr(num_l)
;
for j=0L,num_l-1 do begin
	readf,unit,lr
	lammda=lr[0]
;	radius=lr(1)
	jason_l[j]=lammda/10.	; nm
	readf,unit,fluxes
;	Convert flux into Joule/m^2/s/m/sr
	jason_I[*,j]=[0.0,fluxes[numberangles/2:numberangles-1]/1e16]
endfor
;
free_lun,unit
;
if strupcase(getenv('USER')) eq 'CAH' then $
save,jason_mu,jason_l,jason_I, $
	filename=!atmospheres_dir+'aufdenberg/'+model+'.xdr'
;
end
