function jasongrid,model,lammda,limbdu,fluxes
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return linear or power law limb darkening coefficients on a grid of
; wavelengths for a model specified through teff and logg. These coefficients
; can be integrated by the calling routine over an arbitrary band pass. Note
; that a model from a grid which best matches the inputs is selected.
;
common Jason,jason_mu,jason_l,jason_I
;
; Read atmosphere model
model_file=!atmospheres_dir+'aufdenberg/'+model.model+'.xdr'
r=file_search(model_file)
if strlen(r[0]) ne 0 then restore,model_file $
		     else jasondata,model.model
;
; Obtain coefficients through fit to intensity profile
jason_alpha=fltarr(n_elements(jason_l))
for i=0,n_elements(jason_l)-1 do begin
	y=jason_I[*,i]/jason_I[n_elements(jason_mu)-1,i]*jason_mu
	jason_alpha[i]=-1.0
	integ=1.*int_tabulated(jason_mu,y)
	if model.type eq 5 then jason_alpha[i]=(1./integ)-2.
	if model.type eq 6 then jason_alpha[i]=3.-6.*integ
endfor
;
lammda=jason_l
limbdu=jason_alpha
fluxes=jason_I[n_elements(jason_mu)-1,*]
;
return,0
;
end
