function jd2date,jd_in,df,mjd=mjd,rjd=rjd
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Program returns year, month, day+fraction corresponding to specified Julian
; Day epoch (double precision!, also modified and "reduced" OYSTER epochs).
; Input can be arrays! (From: Numerical Recipes, CUP)
;
jd=jd_in
if n_elements(mjd) eq 0 then mjd=0
if n_elements(rjd) eq 0 then rjd=0
if mjd then jd=jd_in+2400000.5d0
if rjd then jd=jd_in+2440000.5d0
;
jd_long=long(jd)
jdf=jd-jd_long
index=where(jdf ge 0.5,count)
if count gt 0 then begin
	jd_long[index]=jd_long[index]+1
	jdf[index]=jdf[index]-1
endif
a=jd_long
index=where(jd_long ge 2299161L,count)
if count gt 0 then begin
	a[index]=long((jd_long[index]-1867216-0.25)/36524.25)
	a[index]=jd_long[index]+1+a[index]-a[index]/4
endif
b=a+1524
c=long(6680+(b-2439870-122.1)/365.25)
d=long(365*c+c/4)
e=long((b-d)/30.6001)
day=b-d-long(30.6001*e)
month=e-1
index=where(month gt 12,count)
if count gt 0 then month[index]=month[index]-12
year=c-4715
index=where(month gt 2,count)
if count gt 0 then year[index]=year[index]-1
index=where(year lt 0,count)
if count gt 0 then year[index]=year[index]-1
day=day+0.5+jdf
df=day-long(day)
;
return,constrictordate(year,month,day)
;
end
