function jd2jy,jd,mjd=mjd
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute Julian year from Julian date
; if mjd then jd=jd+2400000.5d0
;
if keyword_set(mjd) then begin
	return,2000.0d0+((jd+2400000.5d0)-2451545.0d0)/365.25
endif else begin
	return,2000.0d0+(jd-2451545.0d0)/365.25
endelse
;
end
