function johnson_i,lambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; From: Johnson, 1965, "The Absolute Calibration of the Arizona Photometry".
; lambda in nm.
;
n=26
l=findgen(n)*20+680
t=[0.00,0.01,0.17,0.36,0.56,0.76,0.96,0.98,0.99,1.00,0.98,0.93,0.84,0.71, $
   0.58,0.47,0.36,0.28,0.20,0.15,0.10,0.08,0.05,0.03,0.02,0.00]
;
if n_elements(lambda) eq 0 then begin
	lambda=l
; 	Return "central" wavelength
	return,total(l*t)/total(t)
endif
return,response(l,t,lambda)
;
end
