function johnson_j,lambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; From: Johnson, 1965, "The Absolute Calibration of the Arizona Photometry".
; lambda in nm.
;
n=31
l=findgen(n)*20+960
t=[0.00,0.02,0.03,0.06,0.16,0.35,0.62,0.93,0.85,0.78,0.78,0.80,0.85,0.93, $
   0.75,0.64,0.63,0.63,0.66,0.68,0.70,0.70,0.66,0.60,0.46,0.27,0.14,0.09, $
   0.06,0.02,0.00]
;
if n_elements(lambda) eq 0 then begin
	lambda=l
; 	Return "central" wavelength
	return,total(l*t)/total(t)
endif
return,response(l,t,lambda)
;
end
