function johnson_ks,lambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Here taken from NACO Ks-band filter curve.
; See also: Johnson, 1965, "The Absolute Calibration of the Arizona Photometry".
; lambda in nm.
;
n=29
l=findgen(n)*20+1880
t=[0.00,0.02,0.03,0.10,0.35,0.60,0.64,0.66,0.67,0.68,0.68,0.69,0.69,0.69, $
   0.69,0.70,0.69,0.68,0.68,0.66,0.64,0.63,0.50,0.19,0.05,0.02,0.01,0.01,0.00]
;
if n_elements(lambda) eq 0 then begin
	lambda=l
; 	Return "central" wavelength
	return,total(l*t)/total(t)
endif
return,response(l,t,lambda)
;
end
