function johnson_lp,lambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; L-Prime, which runs from about 3.4 - 4.2 microns, shifted redwards wrt L.
; Here taken from NACO L-band filter curve.
; See also: Johnson, 1965, "The Absolute Calibration of the Arizona Photometry".
; lambda in nm.
;
t=[0.00, 0.01, 0.02, 0.06, 0.23, 0.65, 0.82, 0.90, 0.92, 0.92, 0.94, 0.94, $
   0.95, 0.95, 0.94, 0.94, 0.94, 0.94, 0.93, 0.93, 0.93, 0.94, 0.95, 0.94, $
   0.93, 0.89, 0.65, 0.31, 0.09, 0.03, 0.01, 0.01, 0.00]
l=[3.38, 3.40, 3.42, 3.45, 3.47, 3.50, 3.52, 3.55, 3.57, 3.60, 3.62, 3.65, $
   3.68, 3.70, 3.73, 3.76, 3.79, 3.82, 3.85, 3.88, 3.91, 3.94, 3.97, 4.00, $
   4.03, 4.07, 4.10, 4.13, 4.17, 4.20, 4.24, 4.27, 4.31]*1000
n=n_elements(l)
;
if n_elements(lambda) eq 0 then begin
	lambda=l
; 	Return "central" wavelength
	return,total(l*t)/total(t)
endif
return,response(l,t,lambda)
;
end
