function johnson_m,lambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; From: Johnson, 1965, "The Absolute Calibration of the Arizona Photometry".
; lambda in nm.
;
n=23
l=findgen(n)*100+4100
t=[0.00,0.04,0.25,0.48,1.00,0.93,0.92,0.89,0.84,0.78,0.76,0.79,0.74,0.68, $
   0.60,0.49,0.32,0.26,0.21,0.19,0.09,0.02,0.00]
;
if n_elements(lambda) eq 0 then begin
	lambda=l
; 	Return "central" wavelength
	return,total(l*t)/total(t)
endif
return,response(l,t,lambda)
;
end
