function johnson_n,lambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; From: Johnson, 1965, "The Absolute Calibration of the Arizona Photometry".
; lambda in nm.
;
n=35
l=findgen(n)*200+7000
t=[0.00,0.10,0.34,0.59,0.70,0.76,0.84,0.89,0.98,0.92,0.79,0.68,0.60,0.63, $
   0.69,0.73,0.72,0.65,0.60,0.60,0.61,0.64,0.65,0.68,0.71,0.76,0.76,0.76, $
   0.71,0.63,0.54,0.50,0.46,0.43,0.00]
;
if n_elements(lambda) eq 0 then begin
	lambda=l
; 	Return "central" wavelength
	return,total(l*t)/total(t)
endif
return,response(l,t,lambda)
;
end
