function johnson_r,lambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; From: Johnson, 1965, "The Absolute Calibration of the Arizona Photometry".
; lambda in nm.
;
n=23
l=findgen(n)*20+520
t=[0.00,0.06,0.28,0.50,0.69,0.79,0.88,0.94,0.98,1.00,0.94,0.85,0.73,0.57, $
   0.42,0.31,0.17,0.11,0.06,0.04,0.02,0.01,0.00]
;
if n_elements(lambda) eq 0 then begin
	lambda=l
; 	Return "central" wavelength
	return,total(l*t)/total(t)
endif
return,response(l,t,lambda)
;
end
