function julian,y,m,day,mjd=mjd,rjd=rjd
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Returns Julian Day (Number + fractional part) at 0 hours UT.
; Inputs can be arrays! (From: Numerical Recipes, CUP)
; Input day can be fractional day.
;
if n_elements(mjd) eq 0 then mjd=0
if n_elements(rjd) eq 0 then rjd=0
;
n=n_elements(y)
d=long(day)
df=day-d
;
iy=y
index=where(y lt 0,count)
if count gt 0 then iy[index]=iy[index]+1
im=m+1
index=where(m le 2,count)
if count gt 0 then begin
	iy[index]=iy[index]-1
	im[index]=im[index]+12
endif
bb=lonarr(n)
index=where(d+31L*(m+12L*y) ge (15L+31L*(10L+12L*1582L)),count)
if count gt 0 then begin
	aa=long(iy[index]/100)
	bb[index]=2-aa+long(aa/4)
endif
cc=lonarr(n)
index=where(iy lt 0,count)
if count gt 0 then cc[index]=long((365.25*iy[index])-0.75)
index=where(iy ge 0,count)
if count gt 0 then cc[index]=long(365.25*iy[index])
dd=long(30.6001*im)
jd=bb+cc+dd+d+1720995L
jd=double(jd)-0.5+df
if mjd then jd=jd-2400000.5d0
if rjd then jd=jd-2440000.0d0
if n eq 1 then return,jd[0] else return,jd
;
end
