function jy2m,flux,av=av
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return M-band magnitude for a source with flux in Jy, measured by IRAS,
; for example.
;
flux=float(flux)
;
r=1.03
if n_elements(av) eq 0 then av=0.0
;
m=flux
index=where(flux ne 0,count)
if count gt 0 then m[index]=5.5+av*(1-1/r)-2.5*alog(flux[index])/alog(10)
index=where(flux eq 0,count)
if count gt 0 then m[index]=100
return,m
;
end
