function jy2q,flux
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return Q-band magnitude for a source with flux in Jy, measured by IRAS,
; for example.
;
flux=float(flux)
;
n=flux
index=where(flux ne 0,count)
if count gt 0 then n[index]=2.47-2.5*alog(flux[index])/alog(10)
index=where(flux eq 0,count)
if count gt 0 then n[index]=100
return,n
;
end
