function jy2w3,flux
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return WISE band 3 magnitude for a source with flux in Jy, measured by WISE,
; for example.
; http://morpheus.phys.lsu.edu/~gclayton/magnitude.html
;
flux=float(flux)
;
w1=flux
index=where(flux ne 0,count)
if count gt 0 then w1[index]=-2.5*alog(flux/31.674)/alog(10)
index=where(flux eq 0,count)
if count gt 0 then w1[index]=100
return,w1
;
end
