function k2jy,mag,av=av
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return flux in Jy for a source of K-band magnitude.
; Using Table 7.5 of Infrared Astronomy, in Allen's Astrophysical Quantities
;
; Optionally correct for Av using Rieke and Lebofsky 1985
;
mag=float(mag)
;
r=1.13
if n_elements(av) eq 0 then av=0.0
return,10^(-(mag-av*(1-1/r)-7.1)/2.5)
;
end
