pro k_binaries
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Estimate K1 and K2 for SB1 with orbits and distances.
;
common StarBase,StarTable,Notes
common AstroConstants,m_sun,r_sun,a_unit,s_year
;
index=where((StarTable.a gt 0) $
	and (StarTable.i gt 0) $
	and (StarTable.d gt 0) $
	and (StarTable.e lt 1) $
	and (StarTable.p gt 0),count)
RAD=180.0/!pi
sini=sin(StarTable[index].i/RAD)
if count gt 0 then begin
	asini=StarTable[index].a*StarTable[index].d*a_unit*0.001*sini	; [km]
	Startable[index].a2sini=asini-StarTable[index].a1sini
	StarTable[index].k1= $
		StarTable[index].a1sini $
		/(sqrt(1.0-StarTable[index].e^2)*StarTable[index].p*13751.0)
	StarTable[index].k2= $
		StarTable[index].a2sini $
		/(sqrt(1.0-StarTable[index].e^2)*StarTable[index].p*13751.0)
endif
index=where(StarTable.i eq 0,count)
if count gt 0 then begin
	StarTable[index].k1=0
	StarTable[index].k2=0
endif
;
end
