pro kurudata,filename
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given a Kurucz atmosphere model file (e.g. ip00k2.pck19), read all
; models and save each one using the XDR format. This procedure needs
; to be called only once for installing OYSTER.
;
; The Kurucz models give I(ergs/cm**2/s/hz/ster) whereas filter bandpasses
; in OYSTER are usually expressed in and integrated over wavelength.
; Therefore, the fluxes have to be multiplied by c/lambda^2.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
; First see if 477 xdr files exist. If so, we're done. If not,
; try and extract the xdr files from a Kurucz atmosphere file
SPAWN,'ls '+!atmospheres_dir+'kurucz/*xdr > xdr.list'
nlines = FILE_LINES('xdr.list')
if nlines eq 477 then begin
   print,' '
   print,' Kurucz atmosphere files exist in '+!atmospheres_dir+'kurucz/'
   print,' '
   return
endif
;
file=!atmospheres_dir+'kurucz/'+filename
r=file_search(file)
if strlen(r[0]) eq 0 then begin
	print,'***Error(KURUDATA): file does not exist!'
	return
endif
spawn,'grep TEFF '+file,r
num_model=n_elements(r)
kur_teffs=fltarr(num_model)
kur_loggs=fltarr(num_model)
kur_files=strarr(num_model)
;
case filename of
	'Kurucz_model':	begin
			end
	else:		begin
			num_header=3
			num_rec=1221
			format='(F9.2,E10.3,16F6.0)'
			end
endcase
;
openr,unit,file,/get_lun
line=''
;
for i=0,num_model-1 do begin
	if eof(unit) then begin
		print,'***Error(KURUDATA): unexpected End-of-file!'
		return
	endif
	readf,unit,line,format='(a77)'
	words=nameparse(line)
	kur_teff=float(words[1])
	kur_logg=float(words[3])
	kur_teffs[i]=kur_teff
	kur_loggs[i]=kur_logg
	extn='.'+string(fix(10*kur_logg),format='(i2.2)') $
		+string(long(kur_teff),format='(i5.5)')+'.xdr'
	readf,unit,line
	readf,unit,line,format='(a115)'
	kur_mu=[0.0,reverse(float(nameparse(line)))]
	num_mu=n_elements(kur_mu)
	kur_I=fltarr(num_mu,num_rec)
	kur_l=fltarr(num_rec)
	values=fltarr(num_mu-1+1)
	for j=0,num_rec-1 do begin
		readf,unit,values,format=format
		kur_l[j]=values[0]
		values[2:num_mu-1]=values[2:num_mu-1]/1e5*values[1]
		kur_I[*,j]=[0.0,reverse(values[1:num_mu-1])]*c_light/kur_l[j]^2
	endfor
	index=where(kur_l gt 400 and kur_l le 20000)
	kur_l=kur_l[index]
	kur_I=kur_I[*,index]
	save,kur_teff,kur_logg,kur_mu,kur_l,kur_I,filename=filename+extn
	kur_files[i]=filename+extn
endfor
;
kur_model={kur_teffs:kur_teffs,kur_loggs:kur_loggs,kur_files:kur_files}
save,kur_model,filename=filename+'.models.xdr'
;
end
