function kurugrid,model,lammda,limbdu,fluxes
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return linear or power law limb darkening coefficients on a grid of
; wavelengths for a model specified through teff and logg. These coefficients
; can be integrated by the calling routine over an arbitrary band pass. Note
; that a model from a grid which best matches the inputs is selected.
;
common Kurucz,kur_model,kur_teff,kur_logg,kur_mu,kur_l,kur_I
;
; Find closest model
model_file=kurumodel(model.model,model.teff,model.logg)
if strlen(model_file) ne 0 then restore,model_file
;
; Obtain coefficients through fit to intensity profile
kur_alpha=fltarr(n_elements(kur_l))
for i=0,n_elements(kur_l)-1 do begin
	y=kur_I[*,i]/kur_I[n_elements(kur_mu)-1,i]*kur_mu
	kur_alpha[i]=-1.0
	integ=1.*int_tabulated(kur_mu,y)
	if model.type eq 5 then kur_alpha[i]=(1./integ)-2.
	if model.type eq 6 then kur_alpha[i]=3.-6.*integ
endfor
;
lammda=kur_l
limbdu=kur_alpha
fluxes=kur_I[n_elements(kur_mu)-1,*]
;
return,0
;
end
