function kurumodel,model,teff,logg
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return the model number closest to teff and logg.
;
common LocalKuruModel,model_file_old
common Kurucz,kur_model,kur_teff,kur_logg,kur_mu,kur_l,kur_I
;
if n_elements(model_file_old) eq 0 then model_file_old=''
;
restore,!atmospheres_dir+'kurucz/'+model+'.models.xdr'
;
; Find closest model
d_t=abs(teff[0]-kur_model.kur_teffs)
d_g=abs(logg[0]-kur_model.kur_loggs)
index=where(d_t eq min(d_t)) & j=where(d_g[index] eq min(d_g[index]))
index=index[j[0]]	; in case two equidistant models were found
;
model_file=!atmospheres_dir+'kurucz/'+kur_model.kur_files[index[j]]
if model_file ne model_file_old then begin
        print,'Using model: Teff=',long(kur_model.kur_teffs[index[j]]), $
                ', log(g)=',kur_model.kur_loggs[index[j]],format='(a,i5,a,f3.1)'
	model_file_old=model_file
endif else model_file=''
;
return,model_file
;
end
