function lcmap,model,epochs,mpage
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Setup a call to the Wilson-Devinney (2015) code.
; Model is the binary model. Epochs are JD-2440000.
; Repeat the computations only if any of the parameters changed.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common LocalLcMap1,lcparms,lcparms_p,lcepoch,lcepoch_p,hflx,hkm1,hkm2
common LocalLcMap2,icc,ccc,xcc,ycc,fcc,maps
;
RAD=180/pi_circle
if n_elements(lcparms_p) eq 0 then lcparms_p=''
if n_elements(lcepoch_p) eq 0 then lcepoch_p=''
;
lcparms=setlcparms(model,epochs[0],spotparms)
lcparms[0]=mpage
lcepoch=epochs
n_epochs=n_elements(epochs)
;
; Use this string to decide whether to call lc15 again
lcparms_s=strjoin(string(lcparms))
lcepoch_s=strjoin(string(lcepoch))
;
; Information needed for flux normalization
restore,!oyster_dir+'source/lcdc2015/ibands.xdr'
l0=effwvls[model.wdband-1]*1e-9; lamda [m]
;
IF lcparms_s NE lcparms_p OR lcepoch_s NE lcepoch_p THEN BEGIN
;
lcparms_p=lcparms_s
lcepoch_p=lcepoch_s
;
maxep=200L		; maximum number of epochs, must be same in lc15.f
icc=lonarr(maxep)	; number of fluxes for each map
maxcc=maxep*1000L	; maximum number of elements in following arrays
ccc=lonarr(maxcc)
xcc=dblarr(maxcc)
ycc=dblarr(maxcc)
fcc=dblarr(maxcc)
;
if n_epochs gt maxep then begin
	print,'***ERROR(LC2015): number of epochs larger than MAXEP!'
	return,-1
endif
phas=dblarr(maxep)
hkm1=dblarr(maxep)
hkm2=dblarr(maxep)
hflx=dblarr(maxep)
;
; Correct orbital phases for eclipse phase (binary phase=0)
; The next line in effect until February 21, 2019 (UX Ari, zero eccentricity)
phas[0:n_epochs-1]=((epochs-model.epoch)/model.period mod 1)-wilson(model)
; New code from February 22, 2019, onwards (Alpha Draconis, non-zero ecc.!)
phases=wilson_wd(model)
phas[0:n_epochs-1]=((epochs-model.epoch)/model.period mod 1)+phases[0]
if median(phas) lt 0 then phas=phas+1
;
; Compute orbital phase of secondary's inferior conjunction
phase_p=phases[0]	; corrected periastron (model + 90 degrees)
phase_s=phases[1]	; superior conjunction
phase_i=phases[2]	; inferior conjunction
if model.eccentricity eq 0 then phase_p=0.5
print,'Inferior conjunction at orbital phase:',(phase_i-phase_p) mod 1
;
; Call LC without spots and outside eclipse to normalize flux ratio
;
lcparms[0]=1
phas0p5=double(0.5)
spotparms0=spotparms*0
n_epoch=n_elements(phas0p5)
lcpath=blanks(80)
strput,lcpath,!oyster_dir+'source/lcdc2015'
status=linknload(!external_lib,'lc2015',lcparms,spotparms0, $
	icc,ccc,xcc,ycc,fcc, $
	n_epoch,phas0p5,hkm1,hkm2,hflx,lcpath)
hflx0=hflx[0]
;
; Compute stellar fluxes in erg/s/cm^3 for equivalent physical model
df=1.25	; ratio type 3 diameter to WD diameter
d1=df*2*model.semimajoraxis/lcparms[34]	; mas
d2=df*2*model.semimajoraxis/lcparms[35]	; mas
r1=lcparms[22]/lcparms[34]
r2=lcparms[22]/lcparms[35]
pi=model.semimajoraxis/(lcparms[22]/215)
tm=(model.semimajoraxis/modelpx(model.component))^3/(model.period/365.25)^2
rm=lcparms[36]
m1=tm/(1+rm)
m2=m1*rm
l1=alog10(m1)-2*alog10(r1)+4.44
l2=alog10(m2)-2*alog10(r2)+4.44
f1=stellarfluxes( $
	{teff:lcparms[30]*1e4,logg:l1,diameter:d1,ratio:1.0,type:3}, $
	 l0,ld_coeffs)
f2=stellarfluxes( $
	{teff:lcparms[31]*1e4,logg:l2,diameter:d2,ratio:1.0,type:3}, $
	 l0,ld_coeffs)
;
; Regular LC call
lcparms[0]=mpage
lcpath=blanks(80)
strput,lcpath,!oyster_dir+'source/lcdc2015'
status=linknload(!external_lib,'lc2015',lcparms,spotparms, $
	icc,ccc,xcc,ycc,fcc, $
	n_epochs,phas,hkm1,hkm2,hflx,lcpath)
;
; Convert fluxes to physical
fcc=fcc*(f1+f2)/hflx0
;
if mpage eq 5 then begin
	n=total(icc)
	ccc=ccc[0:n-1]
	xcc=xcc[0:n-1]
	ycc=ycc[0:n-1]
	fcc=fcc[0:n-1]
endif
;
ENDIF
;
case lcparms[0] of
1: 	return,hflx[0:n_epochs-1]
2: 	return,[[hkm1[0:n_epochs-1]],[hkm2[0:n_epochs-1]]]
5: 	begin
	angle=(90-model.ascendingnode)/RAD
	rxcc=(-ycc*sin(angle)+xcc*cos(angle))*model.semimajoraxis
	rycc=(+xcc*sin(angle)+ycc*cos(angle))*model.semimajoraxis
	maps=alloc_maps(icc,ccc,rxcc,rycc,fcc)
	return,maps
	end
endcase
;
end
