function lcpotentials,parameter
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given a binary model for LCDC, return the potentials approximating best
; the given stellar diameters. Also return the corresponding diameters.
;
forward_function setlcparms
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common AstroConstants,m_sun,r_sun,a_unit,s_year
;
index=where(binary_model.method eq 4)
model=binary_model[index[0]]
if componentparse(model.component,comp_1,comp_2) ne 0 then return,-1
star1=where(star_model.component eq comp_1) & star1=star1[0]
star2=where(star_model.component eq comp_2) & star2=star2[0]
model1=star_model[star1]
model2=star_model[star2]
max_spots=2
max_stars=2
spotparms=fltarr(4,max_spots,max_stars)
;
if n_elements(parameter) gt 2 $
then lcparms=parameter $
else lcparms=setlcparms(model,binary_model.epoch,spotparms)
lcparms[0]=1
poth=lcparms[34]
potc=lcparms[35]
;
; Adjust surface potentials to match diameters
maxep=200L		; maximum number of epochs, must be same in lc15.f
icc=1l
ccc=1l
xcc=0.d0
ycc=0.d0
fcc=0.d0
phas=fltarr(maxep)
hkm1=fltarr(maxep)
hkm2=fltarr(maxep)
hflx=fltarr(maxep)
phas0p5=double(0.5)
n_epoch=1L
lcpath=blanks(80)
strput,lcpath,!oyster_dir+'source/lcdc2015'
repeat begin
status=linknload(!external_lib,'lc2015',lcparms,spotparms, $
	icc,ccc,xcc,ycc,fcc, $
	n_epoch,phas0p5,hkm1,hkm2,hflx,lcpath)
;
s=imlcparse(r)*model.semimajoraxis
if total(s) ne 0 then begin
ds=[(model1.diameter/2)-s[0,0],(model2.diameter/2)-s[0,1]]
d_omega1=ds[0]/s[1,0]
d_omega2=ds[1]/s[1,1]
lcparms[34]=lcparms[34]+d_omega1
lcparms[35]=lcparms[35]+d_omega2/10
endif else begin
	print,'Could not read imlcout.dat!'
	d_omega1=0
	d_omega2=0
endelse
endrep until abs(ds[0]/s[0,0]) lt 0.1 and abs(ds[1]/s[0,1]) lt 0.1
poth_adj=lcparms[34]
potc_adj=lcparms[35]
save,poth,potc,poth_adj,potc_adj,filename='imlcout.xdr'
;
au2mas=modelpx(binary_model[0].component)/215
d=s[0,*]*2	; use r_side value
d=r*au2mas*2
if n_elements(parameter) le 2 then parameter=d
;
return,lcparms[34:35]
;
end
