pro limb_stars,range,logarithmic=logarithmic
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; For all stars in the StarTable, compute the quadratic fit coefficients
; to the linear limb darkening coefficients in the interval [450,850] nm,
; unless a different range [nm] is specified.
;
; For larger ranges, e.g. [450,2500], it is recommended to use the
; fit to the logarithmic values of lambda and u.
;
common StarBase,startable,notes
;
if total(startable.teff) eq 0 then begin
	print,'***Error(LIMB_STARS): all effective temperatures zero!'
	return
endif
if total(startable.class) eq 0 then begin
	print,'***Error(LIMB_STARS): all classes equal to zero!'
	return
endif
;
if n_elements(range) eq 0 then range=[450.0,850.0]
if not keyword_set(logarithmic) then logarithmic=0
;
for i=0L,n_elements(startable)-1 do begin
	if startable[i].teff ne 0 and startable[i].class ne 0 then begin
        	if limbgrid(startable[i].teff,startable[i].logg, $
			lamda,limbdu,fluxes) ne 0 then return
		index=where(lamda gt range[0] and lamda lt range[1])
		x=lamda[index]
		y=limbdu[index]
		if logarithmic then begin
;			In this case, abs(A1) will be larger than 0.01
			x=alog10(x)
			y=alog10(y)
		endif
		r=poly_fit(x,y,2)
        	startable[i].a0=r[0]
        	startable[i].a1=r[1]
        	startable[i].a2=r[2]
	endif
endfor
;
end
