function limbband,teff,logg,clambda,dlambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Integrate linear limb darkening coefficients over rectangular band pass
; defined through center wavelength clambda [nm] and full width dlambda.
;
if limbgrid(teff,logg,lammda,limbdu,fluxes) ne 0 then return,-1
;
num=n_elements(lammda)
transmission=fltarr(num)
;
n=n_elements(clambda)
tu=fltarr(n)
;
for i=0,n-1 do begin
;
	transmission[*]=0
	index=where(abs(lammda-clambda[i]) lt dlambda[i]/2,count)
	if count gt 0 then begin
		transmission[index]=1
		tm=transmission*fluxes
		tu[i]=total(tm*limbdu)/total(tm)
	endif else begin
;		If the grid is not fine enough
		tu[i]=interpol(limbdu,lammda,clambda[i])
	endelse
;
endfor
;
return,tu
;
end
