function limbfactor,coeff
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return the factor which converts a uniform disk diameter
; to a limb darkened diameter using Hanbury Browns formula
; (Hanbury Brown et al. 1974, "The effect of limb-darkening...")
;
return,sqrt((1-coeff/3)/(1-7*coeff/15))
;
end
