function limbfilter,teff,logg,filter
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Integrate linear limb darkening coefficients over a named filter.
; Model atmosphere parameters teff and logg in K and cgs, respectively.
;
if limbgrid(teff,logg,lammda,limbdu,fluxes) ne 0 then return,-1
;
if n_elements(filter) eq 0 then begin
	print,'***Error(LIMBFILTER): no filter specified!'
	return,-1
endif
;
case filter of
'U':	begin
	tm=johnson_u(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'B':	begin
	tm=johnson_b(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'V':	begin
	tm=johnson_v(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'R':	begin
	tm=johnson_r(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'I':	begin
	tm=johnson_i(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'J':	begin
	tm=johnson_j(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'H':	begin
	tm=johnson_h(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'K':	begin
	tm=johnson_k(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'Hp':	begin
	tm=hipparcos_hp(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'u': 	begin
	tm=stroemgren_u(lammda)*atmosphere(lammda)*aluminium(lammda)^2 $
	  *pm1p21(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'v': 	begin
	tm=stroemgren_v(lammda)*atmosphere(lammda)*aluminium(lammda)^2 $
	  *pm1p21(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'b': 	begin
	tm=stroemgren_b(lammda)*atmosphere(lammda)*aluminium(lammda)^2 $
	  *pm1p21(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'y': 	begin
	tm=stroemgren_y(lammda)*atmosphere(lammda)*aluminium(lammda)^2 $
	  *pm1p21(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'm800': begin
	tm=mark3_800(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'm550': begin
	tm=mark3_550(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'm500': begin
	tm=mark3_500(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'm450': begin
	tm=mark3_450(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'mhan': begin
	tm=mark3_han(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'mhab': begin
	tm=mark3_hab(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
'm500o':begin
	tm=mark3_500o(lammda)*fluxes
	tu=total(tm*limbdu)/total(tm)
	end
else:	begin
	print,'Warning(LIMBFILTER): unknown filter!'
	tu=-1
	end
endcase
;
return,tu
;
end
