function limbfluxes,teff,logg,lammda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return interpolated array of model atmosphere fluxes for
; input array of wavelengths lambda, and stellar model atmosphere for
; T_eff=teff and log(g)=logg. Lambda is in nm.
;
; Get fluxes on Van Hamme's grid
s=limbgrid(teff,logg,mlambda,mlimbdu,mfluxes)
;
; High tension (10) spline, i.e. nearly equal linear interpolation
return,spline(mlambda,mfluxes,lammda,10)
;
end
