function limbgrid,teff,logg,lammda,limbdu,fluxes,quiet=quiet,closest=closest
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return linear limb darkening coefficients on a grid of wavelengths for
; a model specified through teff and logg. These coefficients can be integrated
; by the calling routine over an arbitrary band pass. Note that a model from
; a grid which best matches the inputs is selected. The model atmosphere
; data was computed by Van Hamme. "Interpolate" to the requested Teff
; using the ratio of the black body spectra at the requested and grid Teff.
;
common LimbBase,limb_data
common LocalLimbgrid,blackbody_notification
;
if n_elements(blackbody_notification) eq 0 then blackbody_notification=1 $
					   else blackbody_notification=0
;
if n_elements(quiet) eq 0 then quiet=0
if n_elements(closest) eq 0 then closest=0
;
if n_elements(limb_data) eq 0 then limbdata,/restore
;
if teff eq 0 then begin
	print,'Error (limbgrid): Teff zero on input!'
	return,0
endif
;
; Find closest model(s)
models=limbmodel(limb_data.m,limb_data.t,limb_data.g,teff,logg,teff_model, $
	closest=closest)
;
; Extract corresponding grid
index=where(limb_data.n eq models[0])
lammda=limb_data.w[index]
limbdu=limb_data.u[index]
fluxes=limb_data.f[index]
; The following is experimental when a cool star grid is requested
mndex=where(limb_data.m eq models[0])
if teff lt unique(limb_data.t[mndex]) then begin
	if not quiet and blackbody_notification then $
		print,'Using matching blackbody!'
;	Use scale black body when Kurucz template is not available
	rt=[-703.571,1.15714]		; Coefficients for blackbody Teff
	rs=[1.72650,-0.000128975]	; Coefficients for scale factor
	l=lammda*1e-9
	fluxes=blackbody(poly(teff,rt),l)*poly(teff,rs)
	return,0
endif
;
; If two (different) models are returned...
if n_elements(models) eq 2 then begin
if models[0] ne models[1] then begin
	index=where(limb_data.n eq models[1])
	lammda2=limb_data.w[index]	; should be identical to lammda
	limbdu2=limb_data.u[index]
	fluxes2=limb_data.f[index]
	t1=alog10(limb_data.t[where(limb_data.m eq models[0])]) & t1=t1[0]
	t2=alog10(limb_data.t[where(limb_data.m eq models[1])]) & t2=t2[0]
; 	Interpolate fluxes between the two
	f1=alog10(fluxes)
	f2=alog10(fluxes2)
	f=f1+(f2-f1)*(alog10(teff)-t1)/(t2-t1)
	fluxes=10^f
; 	Interpolate limb darkening coefficient between the two
	u1=limbdu
	u2=limbdu2
	u=u1+(u2-u1)*(alog10(teff)-t1)/(t2-t1)
endif
endif
;
return,0
;
end
